# 🔧 Hikvision Device Setup Guide

Quick guide to configure your Hikvision DS-K1T320EFWX device.

## Step 1: Access Device Web Interface

Open browser and go to:
```
https://192.168.1.73/doc/index.html
```

Login with admin credentials.

---

## Step 2: Configure HTTP Listening

### Navigate:
```
System → Configuration → Network → Advanced Settings → HTTP Listening
```

### Configure:

#### HTTPS Settings:
- ✅ **Enable HTTPS**: Yes
- **HTTPS Port**: `443`

#### HTTP Settings (optional):
- **Enable HTTP**: Yes (if needed)
- **HTTP Port**: `80`

---

## Step 3: Configure Event Notification

### In HTTP Listening section:

**Event Alarm IP/Domain Name:**
```
dev.ntranepal.edu.np
```

**URL:**
```
/attendance100/webhook.php
```

**Port:**
```
443  (for HTTPS)
or
80   (for HTTP)
```

**Method:**
```
POST
```

### Click **Save**

---

## Step 4: Add Employees

### Navigate:
```
Person Management → Person
```

### Click **Add Person**

#### Employee Information:
- **Employee ID**: 
  - For staff: `emp115275`
  - For students: `stu12345`
- **Name**: Full name
- **Department**: Select or create department

#### Enroll Credentials:
1. **Card**: Tap card to enroll
2. **Fingerprint**: Scan fingerprint
3. **Face**: Take photo

### Click **Save**

---

## Step 5: Test

1. Have employee tap card/fingerprint
2. Device should show success message
3. Check your website:
   ```
   https://dev.ntranepal.edu.np/attendance100/
   ```
4. Attendance should appear

---

## Device Information Reference

From your device (found at Configuration → System → System Settings):

```
Device Name:    Access Controller
Model:          DS-K1T320EFWX
Serial Number:  DS-K1T320EFWX20240701V030502ENFT5983414
MAC Address:    a4:d5:c2:14:dd:73
IP Address:     192.168.1.73
Firmware:       V3.5.2 build 240701
```

---

## URL Configuration Summary

| Setting | Value |
|---------|-------|
| Domain | `dev.ntranepal.edu.np` |
| Path | `/attendance100/webhook.php` |
| Full URL | `https://dev.ntranepal.edu.np/attendance100/webhook.php` |
| Method | POST |
| Port | 443 (HTTPS) or 80 (HTTP) |

---

## Employee ID Format

### For Staff:
```
Format: empXXXXX
Example: emp115275
```

### For Students:
```
Format: stuXXXXX
Example: stu12345
```

**Important**: The prefix determines attendance type:
- `emp*` → Staff attendance
- `stu*` → Student In/Out (based on time)

---

## Testing Connection

### Test 1: Ping Test
```bash
ping dev.ntranepal.edu.np
```
Should resolve and respond.

### Test 2: URL Test
From device terminal or browser:
```
https://dev.ntranepal.edu.np/attendance100/webhook.php
```
Should show: "Method not allowed" (405) - This is correct! Means endpoint is reachable.

### Test 3: Actual Tap
- Have someone tap card
- Watch device screen for success/error
- Check website immediately

---

## Common Issues

### Issue: Device shows "Connection Failed"
**Solutions:**
- Check internet connection
- Verify domain name is correct
- Try using IP instead of domain (for testing)
- Check firewall settings

### Issue: Device shows "Authentication Failed"
**Solutions:**
- Verify URL path is correct: `/attendance100/webhook.php`
- Check HTTPS/HTTP port matches
- Ensure no extra spaces in URL

### Issue: No error but no attendance on website
**Solutions:**
- Check employee ID starts with `emp` or `stu`
- Verify date/time on device is correct
- Check attendance.json file exists and is writable

---

## Network Requirements

Device must be able to:
- ✅ Reach internet
- ✅ Resolve DNS (dev.ntranepal.edu.np)
- ✅ Make HTTPS/HTTP POST requests
- ✅ Access port 443 (HTTPS) or 80 (HTTP)

---

## Screenshot Locations

### HTTP Listening Settings:
```
System → Configuration → Network → Advanced Settings → HTTP Listening
```
Look for:
- [ ] Enable checkbox
- [ ] Port field
- [ ] Event Alarm IP/Domain Name field
- [ ] URL field
- [ ] Port field

### Person Management:
```
Person Management → Person → Add
```
Look for:
- [ ] Employee ID field (most important!)
- [ ] Name field
- [ ] Department dropdown
- [ ] Card/Fingerprint/Face enrollment buttons

---

## Quick Reference

**Device IP**: 192.168.1.73  
**Website**: https://dev.ntranepal.edu.np/attendance100/  
**Webhook**: https://dev.ntranepal.edu.np/attendance100/webhook.php  
**Your Device MAC**: a4:d5:c2:14:dd:73  
**Your Device Serial**: DS-K1T320EFWX20240701V030502ENFT5983414

---

## Support

If issues persist, check:
1. Device network settings
2. Website accessibility (open in browser)
3. attendance.json file (should contain data after tap)
4. Device system logs
