# ✅ ATTENDANCE100 - MINIMAL MVP

## 📦 What's Included

**Just 3 files** to demonstrate core functionality:

1. **index.php** (96 lines) - Dashboard to view attendance
2. **webhook.php** (75 lines) - Receives data from device  
3. **README.md** - Quick start guide

Plus 2 setup guides:
- **DEVICE_SETUP.md** - Configure Hikvision device
- **WEBSITE_SETUP.md** - Deploy to server

**Total: 2 PHP files + 1 JSON (auto-created) = Core system**

---

## 🎯 Core Features Only

✅ Receive attendance from Hikvision device  
✅ Store in JSON file (attendance.json)  
✅ Display in simple dashboard  
✅ Filter by type (Student In/Out, Staff)  
✅ Auto-categorize by employee ID prefix  
✅ Real-time stats  
✅ Auto-refresh every 30 seconds  

---

## 🚀 Quick Start

### 1. Upload
```
Upload folder to: /public_html/attendance100/
```

### 2. Configure Device
```
URL: https://dev.ntranepal.edu.np/attendance100/webhook.php
Method: POST
```

### 3. Add Employee
```
Employee ID: emp115275 (staff) or stu12345 (student)
```

### 4. Test
```
Tap card → Check: https://dev.ntranepal.edu.np/attendance100/
```

---

## 📊 How It Works

```
Employee taps device
        ↓
Device POSTs to webhook.php
        ↓
Validates & saves to attendance.json
        ↓
index.php displays records
```

---

## 🔧 Employee ID Logic

- **emp*** → Staff attendance
- **stu*** (AM) → Student In
- **stu*** (PM) → Student Out

---

## 📁 File Structure

```
attendance100/
├── index.php              # Dashboard (view)
├── webhook.php            # Receiver (logic)
├── attendance.json        # Data (auto-created)
├── README.md              # Quick guide
├── DEVICE_SETUP.md        # Device config
├── WEBSITE_SETUP.md       # Server setup
└── SUMMARY.md             # This file
```

---

## 🎨 Why Minimal?

- ✅ Easy to understand (96 + 75 = 171 lines total)
- ✅ No framework dependencies
- ✅ No database setup
- ✅ Quick deployment (< 5 minutes)
- ✅ Ready to extend with MVC later
- ✅ Perfect for learning implementation

---

## 📖 Read Next

1. **README.md** - Start here for quick setup
2. **DEVICE_SETUP.md** - Configure your device
3. **WEBSITE_SETUP.md** - Deploy to server

---

## 🔄 Future Extensions

This minimal version demonstrates the core. Later you can add:

- MVC architecture
- Database (MySQL/PostgreSQL)
- User authentication
- Reports & exports
- Email notifications
- Multiple devices
- Employee management
- Departments
- Shifts

But for now, **it works!**

---

## ✨ Location

```
c:\Users\Upendra237\Desktop\FinalCode (2)\School-Main\attendance100\
```

Upload this folder to your server and you're done! 🎉

---

**Deployment URL**: https://dev.ntranepal.edu.np/attendance100/  
**Webhook URL**: https://dev.ntranepal.edu.np/attendance100/webhook.php
